;*********************************************************************
;                                                                    *
;                       Software License Agreement                   *
;                                                                    *
;   The software supplied herewith by Microchip Technology           *
;   Incorporated (the "Company") for its dsPIC controller            *
;   is intended and supplied to you, the Company's customer,         *
;   for use solely and exclusively on Microchip dsPIC                *
;   products. The software is owned by the Company and/or its        *
;   supplier, and is protected under applicable copyright laws. All  *
;   rights are reserved. Any use in violation of the foregoing       *
;   restrictions may subject the user to criminal sanctions under    *
;   applicable laws, as well as to civil liability for the breach of *
;   the terms and conditions of this license.                        *
;                                                                    *
;   THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
;   WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
;   BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
;   FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
;   COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
;   INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
;                                                                    *
;   (c) Copyright 2003 Microchip Technology, All rights reserved.    *
;*********************************************************************

	; Local inclusions.
	.nolist
	.include	"dspcommon.inc"		; PSVPAG, COEFFS_IN_DATA,
						; kSof
	.list

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; IIR Canonic filter structure access.
	.equ oNumSectionsLess1,0	; IIRCanonic->numSectionsLess1 : (int)
					; number second order sections minus one
	.equ oCoeffs,(oNumSectionsLess1+kSof)
					; IIRCanonic->coeffsBase : (fractional*)
					; pointer to filter coefficients
					; number of coefficients is 
					; 5 * number of second order sections
					; organized as {a2, a1, b2, b1, b0}
	.equ oPSVpage,(oCoeffs+kSof)	; IIRCanonic->CoeffsPage : (int)
					; page number in program memory if
					; coefficients are in program memory
					; 0xFF00 if not
	.equ oStates,(oPSVpage+kSof)	; IIRCanonic->delayBase : (fractional*)
					; pointer to filter states
					; two words for every section
	.equ oInitialGain,(oStates+kSof)
					; IIRCanonic->inititalGain:(fractional)
					; initial gain value
	.equ oFinalShift,(oInitialGain+kSof)
					; IIRCanonic->finalShift : (int)
					; final shift count (left)
					; restores filter gain to 0 dB
					; shift count may be zero
					; if not zero, it is the number of bits
					; to shift the output to the left
					; negative value means shift left

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.section .libdsp, code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; _IIRCanonic: Cascade of second order IIR Canonic FORM II filtering.
; This file should be assembled and linked against filter coefficients
; generated by dsPicFD -- filter design software by Momentum Data Systems. 
; 
; Operation: cascade of S sections
;
;		 (b2_s*x[n-2] + b1_s*x[n-1] + b0_s*x[n])
;	y_s[n] = ---------------------------------------
;			(a2_s*y[n-2] + a1_s*y[n-1])
;
; Input:		
;	w0 = number of samples to generate (numSamps, N)
;	w1 = ptr to output samples (dstSamps, y)
;	w2 = ptr to input samples (srcSamps, x)
;	w3 = filter structure (IIRCanonicStruct, h)
;
; Return:
;	w0 = ptr to output samples (dstSamps, y)
;
; System resources usage:
;	{w0..w7}	used, not restored
;	{w8..w11}	saved, used, restored
;	 AccuA		used, not restored
;	 CORCON		saved, used, restored
;	 PSVPAG		saved, used, restored (if coeffs in program memory)
;
; DO and REPEAT instruction usage.
;	2 level DO instructions
;	no REPEAT intructions
;
; Program words (24-bit instructions):
;	42
;
; Cycles (including C-function call and return overheads):
;	36 + N*(8 +  7*S), or
;	39 + N*(9 + 12*S) if coefficients in program memory,
; with S the number of second order sections.
;............................................................................

	.global	_IIRCanonic	; export
_IIRCanonic:

;............................................................................

	; Save working registers.
	push.d	w8				; {w8,w9} to TOS
	push.d	w10				; {w10,w11} to TOS

;............................................................................

	; Prepare CORCON for fractional computation.
	push	CORCON
	fractsetup	w8

;............................................................................

	; Prepare CORCON and PSVPAG for possible access of data
	; located in program memory, using the PSV.
	push	PSVPAG

;............................................................................

	push	w1				; save return value (dstSamps)

;............................................................................

	mov	[w3+oPSVpage],w10		; w10= coefficients page
	mov	#COEFFS_IN_DATA,w8		; w8 = COEFFS_IN_DATA
	cp	w8,w10				; w8 - w10
	bra	z,_noPSV			; if w10 = COEFFS_IN_DATA
						; no PSV management
						; else
	psvaccess	w8			; enable PSV bit in CORCON
	mov	w10,PSVPAG			; load PSVPAG with program
						; space page offset
_noPSV:

;............................................................................

	; Perpare to filter.
	mov	[w3+oNumSectionsLess1],w9	; w9 = number of sections - 1
	mov	[w3+oInitialGain],w4		; w4 = initial gain
	mov	[w3+oFinalShift],w11		; w11= final shift
	dec	w0,w0				; w0 = N-1

;............................................................................

	; Perform filtering of all samples.
	do	w0,_endFilter		; {	; do (N-1)+1 times

	; Prepare biquadratic sections.
	mov	[w3+oCoeffs],w8			; w8 = base address of coeffs
	mov	[w3+oStates],w10		; w10= base address of states

	; Fetch next sample.
	mov	[w2++],w6			; w6 = x[n]
						; w2-> x[n+1]

	; Apply initial gain, and prepare to filter sample.
	mpy	w4*w6,a,[w8]+=2,w5,[w10]+=2,w6	; a  = gain*x[n]
						; w5 = a2 current section
						; w8-> a1 current section
						; w6 = del[2] current section
						; w10->del[1] current section

	; Apply cascade of sections.
	do	w9,_endSections

	mac	w5*w6,a,[w8]+=2,w5,[w10]-=2,w7	; a += a2*del[2]
						; w5 = a1 current section
						; w8-> b2 current section
						; w7 = del[1] current section
						; w10->del[2] current section
	mac	w5*w7,a,[w8]+=2,w5		; a += a1*del[1]
						; w5 = b2 current section
						; w8-> b1 current section
	mov	w7,[w10++]			; del[2] = del[1] (update)
						; w10->del[1] current section
	sac.r	a,#-1,[w10]			; del[1] = rnd(a<1) (update)
	mpy	w5*w6,a,[w8]+=2,w5		; a  = b2*del[2]
						; w5 = b1 current section
						; w8-> b0 current section
	mac	w5*w7,a,[w8]+=2,w5,[w10]+=2,w6	; a += b1*del[1]
						; w5 = b0 current section
						; w8-> a2 next section
						; w6 = backward branch state
						; w10->del[2] next section
_endSections:
	mac	w5*w6,a,[w8]+=2,w5,[w10]+=2,w6	; a += b0*(backward state)
						; w5 = a2 next section
						; w8-> a1 next section
						; w6 = del[2] next section
						; w10->del[1] next section

	; Apply final shift.
	sftac	a,w11				; restore section dB gain
_endFilter:

	; Round and store output.
	sac.r	a,#-1,[w1++]			; y[n] = rnd(a<1)
						; w1-> y[n+1]

;............................................................................

	pop	w0				; restore return value

;............................................................................

	; Restore PSVPAG and CORCON.
	pop	PSVPAG
	pop	CORCON

;............................................................................

	; Restore working registers.
	pop.d	w10				; {w10,w11} from TOS
	pop.d	w8				; {w8,w9} from TOS

;............................................................................

	return	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;############################################################################

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
; _IIRCanonicInit: IIR Canonic FORM II filter cascade initialization.
; 
; Operation:
;	filter->state[n][0] = 0,	and
;	filter->state[n][1] = 0,	0 <= n <= filter->numSectionsLess1
;
; Input:		
;	w0 = filter structure (filter, h)
;
; Return:
;	(void)
;
; System resources usage:
;	{w0..w1}	used, not restored
;
; DO and REPEAT instruction usage.
;	1 level DO instructions
;	no REPEAT intructions
;
; Program words (24-bit instructions):
;	7
;
; Cycles (including C-function call and return overheads):
;	10 + 2*S,
; with S the number of second order sections.
;............................................................................

	.global _IIRCanonicInit

_IIRCanonicInit:
		
;............................................................................

	; Prepare operation.
	mov	[w0+oNumSectionsLess1],w1		; w1 = num sections -1
	mov	[w0+oStates],w0				; w0-> delayBase[0]

;............................................................................

	; Perform operation.
	do	w1,canonicInitLoop		; do num sections times
	clr	[w0++]				; delayBase[m][1] = 0
						; w1-> delayBase[m][2]
canonicInitLoop:		
	clr	[w0++]				; delayBase[m][2] = 0
						; w1-> delayBase[m+1][1]

;............................................................................

	return	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; OEF
